//glphdwdf.h
/*----------------------------------
Defs fuer GALEP und Kernel-Mode;
----------------------------------*/
#ifndef __GLPHDWDF__
#define __GLPHDWDF__

/*-----------------------------------------
//Zustandsdefinitionen der Schnittstelle;
------------------------------------------*/
#define CLOCK_MODE 0 //Decoder DC3_8 aktiv;
#define LATCH_MODE 1 //Decoder DO2_4 aktiv;

//Adressdefinitionen fuer die beiden Zustnde
//#define 	ADR_MODSWT	0x70

#define LOW 	0
#define HIGH 	1
//CLOCK_MODE Demultiplexer DC3_8 ***********************************************
#define 	ADR_Q0				0x00
#define 	ADR_Q1				0x10
#define 	ADR_Q2				0x20
#define 	ADR_Q3			  	0x30
#define 	ADR_Q4			  	0x40
#define 	ADR_Q5			  	0x50
#define 	ADR_Q6				0x60
#define     ADR_Q7				0x70

//LATCH_MODE *******************************************************************
//Im LATCH_MODE wird die Adresse durch die Datenbits PC0, PC1, PC2, PC5 und PC6 gebildet.
//1. Latch
#define 	ADR_L1_Q00		 	0x00
#define 	ADR_L1_Q10 			0x01
#define 	ADR_L1_Q20			0x02
#define 	ADR_L1_Q30			0x03
#define	    ADR_L1_Q40			0x04
#define     ADR_L1_Q50			0x05
#define     ADR_L1_Q60			0x06
#define     ADR_L1_Q70			0x07

//2. Latch
#define 	ADR_L2_Q00		 	0x20
#define 	ADR_L2_Q10 			0x21
#define 	ADR_L2_Q20			0x22
#define 	ADR_L2_Q30			0x23
#define	    ADR_L2_Q40			0x24
#define     ADR_L2_Q50			0x25
#define     ADR_L2_Q60			0x26
#define     ADR_L2_Q70			0x27


//3. Latch
#define 	ADR_L3_Q00		 	0x40
#define 	ADR_L3_Q10 			0x41
#define 	ADR_L3_Q20			0x42
#define 	ADR_L3_Q30			0x43
#define	    ADR_L3_Q40			0x44
#define     ADR_L3_Q50			0x45
#define     ADR_L3_Q60			0x46
#define     ADR_L3_Q70			0x47


//defines fuer die Ruecklesekanaele;
#define     OUT_D0		0x0
#define     OUT_D1		0x2
#define     OUT_D2		0x4
#define     OUT_D3		0x6
#define 	OUT_D4		0x8
#define	    OUT_D5		0xA
#define	    OUT_D6		0xC
#define	    OUT_D7		0xE

//defines an welchen Pin der Programmierimpuls erscheinen soll;
#define 	PGMOUT_D0 0x0
#define 	PGMOUT_D1 0x1
#define 	PGMOUT_D2 0x2
#define 	PGMOUT_D3 0x3

//Datenbits PD3 und PD4 fuer LATCH_MODE;
#define D0_HIGH	    0x08
#define D1_HIGH     0x10

//DAC-Output A  und B
#define DAC_OUTA 	0x0100
#define DAC_OUTB	0x0200

#define F_DAC_A	10.76523f	//Kennliniensteigung von DAC A
#define F_DAC_B   10.71503f	//Kennliniensteigung von DAC B

#define SCAN_OFFSET_THRESHOLD 10.833f


//Definitionen zur Steuerung der Vcp1-Treiberregister;
#define VCP1_11 	0x80000ul
#define VCP1_12 	0x40000ul
#define VCP1_13 	0x20000ul
#define VCP1_14     0x10000ul
#define VCP1_18 	0x08000ul
#define VCP1_24 	0x04000ul
#define VCP1_25 	0x02000ul
#define VCP1_32 	0x01000ul
#define VCP1_34 	0x00800ul
#define VCP1_36 	0x00400ul
#define VCP1_40 	0x00200ul
#define VCP1_16     0x00100ul

//Definitionen zur Steuerung der Vcp1-Treiberregister;
#define VCP2_1		0x80000ul
#define VCP2_5      0x40000ul
#define VCP2_7      0x20000ul
#define VCP2_8      0x10000ul
#define VCP2_9      0x08000ul
#define VCP2_10     0x04000ul
#define VCP2_11     0x02000ul
#define VCP2_12     0x01000ul
#define VCP2_13     0x00800ul
#define VCP2_15     0x00400ul
#define VCP2_20     0x00200ul
#define VCP2_21     0x00100ul
#define VCP2_28     0x00080ul
#define VCP2_29     0x00040ul
#define VCP2_30     0x00020ul
#define VCP2_31     0x00010ul
#define VCP2_14     0x00008ul
#define VCP2_26     0x00004ul 

//Definitionen zur Steuerung der Gnd-Treiberregister;
#define GND10 	 	0x8000
#define GND11	  	0x4000
#define GND12  	    0x2000
#define GND16  	    0x1000
#define GND20  	    0x0800
#define GND21		0x0400
#define GND25		0x0200
#define GND26    	0x0100

#define GND27		0x0080
#define GND30		0x0040
#define GND31		0x0020
#define GND40		0x0010
#define GND34		0x0008
#define GNDUMMY3	0x0004
#define GNDUMMY4	0x0002
#define GNDUMMY5	0x0001





#endif  __GLPHDWDF__

