#ifndef glp_cmd_hw_comm_h
  #define glp_cmd_hw_comm_h

#include "../h/glp_devcfg.h"
#include "../h/glp_types.h"

// type definitions
// [
#define uint unsigned int
// ]

#define ucInterfaceMode pCmdBuf->status.ucInterfaceMode


void hwcSwitchInterfaceMode(uchar bMode);
void hwcSetReadbackChannel(uchar bChannel);
void hwcSoftwareReset();

void hwcSetL1_Q00();
void hwcSetL1_Q01();
void hwcSetL1_Q10();
void hwcSetL1_Q11();
void hwcSetL1_Q20();
void hwcSetL1_Q21();
void hwcSetL1_Q30();
void hwcSetL1_Q31();
void hwcSetL1_Q40();
void hwcSetL1_Q41();
void hwcSetL1_Q50();
void hwcSetL1_Q51();
void hwcSetL1_Q60();
void hwcSetL1_Q61();
void hwcSetL1_Q70();
void hwcSetL1_Q71();

void hwcResetL1_Q00();
void hwcResetL1_Q01();
void hwcResetL1_Q10();
void hwcResetL1_Q11();
void hwcResetL1_Q20();
void hwcResetL1_Q21();
void hwcResetL1_Q30();
void hwcResetL1_Q31();
void hwcResetL1_Q40();
void hwcResetL1_Q41();
void hwcResetL1_Q50();
void hwcResetL1_Q51();
void hwcResetL1_Q60();
void hwcResetL1_Q61();
void hwcResetL1_Q70();
void hwcResetL1_Q71();


void hwcSetL2_Q00();
void hwcSetL2_Q01();
void hwcSetL2_Q10();
void hwcSetL2_Q11();
void hwcSetL2_Q20();
void hwcSetL2_Q21();
void hwcSetL2_Q30();
void hwcSetL2_Q31();
void hwcSetL2_Q40();
void hwcSetL2_Q41();
void hwcSetL2_Q50();
void hwcSetL2_Q51();
void hwcSetL2_Q60();
void hwcSetL2_Q61();
void hwcSetL2_Q70();
void hwcSetL2_Q71();

void hwcResetL2_Q00();
void hwcResetL2_Q01();
void hwcResetL2_Q10();
void hwcResetL2_Q11();
void hwcResetL2_Q20();
void hwcResetL2_Q21();
void hwcResetL2_Q30();
void hwcResetL2_Q31();
void hwcResetL2_Q40();
void hwcResetL2_Q41();
void hwcResetL2_Q50();
void hwcResetL2_Q51();
void hwcResetL2_Q60();
void hwcResetL2_Q61();
void hwcResetL2_Q70();
void hwcResetL2_Q71();


// SpeedUp functions //
void hwcSetM0();
void hwcResetM0();
void hwcSetM1();
void hwcResetM1();
void hwcSetEndo();
void hwcResetEndo();

uint hwcReadDataRegByte();
uint hwcReadDataRegWord();
dword hwcReadDataRegPin1_20();
dword hwcReadDataRegPin21_40();
dword hwcMeasureBusySpeed();
uint hwcCalcTimerValue(dword dUSec);
void hwcLoadTimerSerReg(uint iTimerVal);
void hwcStartPgmImpulse();
dword hwcWaitForNotBusy();

#undef uint

#endif // glp_cmd_hw_comm_h
