#ifndef glp_device_h
  #define glp_device_h


#define dword unsigned long
#define uchar unsigned char


// ioctl basics
// [
#define GLP_LPT_IOC_MAGIC                                       0x69                            // it's magic //
#define GLP_LPT_IOC_MAXNR                                          1
#define SAMPLEDRV_IOC_MAXNR 1
// ]

// ioctl section
// [
#define GLP_IOCTL_SET_LPT_ADR                                    _IO(GLP_LPT_IOC_MAGIC, 1)      // SET LPT-Base Adr //
#define GLP_IOCTL_GET_LPT_ADR                                    _IO(GLP_LPT_IOC_MAGIC, 2)      // GET LPT-Base Adr //
#define GLP_IOCTL_EXECUTE_BUFFER                                 _IO(GLP_LPT_IOC_MAGIC, 3)      // execute buffer //
#define GLP_IOCTL_GET_DEVCFG                                     _IO(GLP_LPT_IOC_MAGIC, 4)      // get timing parameters //
#define GLP_IOCTL_SET_DEVCFG                                     _IO(GLP_LPT_IOC_MAGIC, 5)      // set timing parameters //
// ]

// cmdExecute definition
// [
#define GLP_ERR_EXECUTE_INVINSTR                                1               // invalid instruction
// ]




// DEBUG ioctl definition //
/*
// [
#define GLP_IOCTL_SET_SPEED_TEST_LENGTH                          _IO(GLP_LPT_IOC_MAGIC, 200)    // jitter test //
#define GLP_IOCTL_TEST_SPEED                                     _IO(GLP_LPT_IOC_MAGIC, 201)    // jitter test //
// ]
*/

#define GLP_IOCTL_PARANOYA_TEST                                    _IO(GLP_LPT_IOC_MAGIC, 202)



// constant definition
// [
#define GLP_CMD_NUM_BUFFER_MAX                                  5000    // instruction buffer
#define GLP_RET_NUM_BUFFER_MAX                                  50      // return buffer
// ]

// structure definitions //
// [

// GLP_IOCTL_SET_LPT_ADR, GLP_IOCTL_GET_LPT_ADR //
struct tGLPAdrLPT
  {
    int iIOPortAddr;
    int iSTPortAddr;
    int iCTPortAddr;
  };
// ]



// datastructures associated wih buffer transfer / execution //
// buffer- / instruction management

// GLP_IOCTL_EXECUTE_BUFFER
// [
struct tGLPCommand
  {
    dword aArg;
    dword aCmd;
  };

struct tGLPDevState
  {
    // latch "1" signals
    uchar L1_Q00, L1_Q01, L1_Q10, L1_Q11, L1_Q20, L1_Q21, L1_Q30, L1_Q31, L1_Q40, L1_Q41, L1_Q50, L1_Q51, L1_Q60, L1_Q61, L1_Q70, L1_Q71;
    // latch "2" signals
    uchar L2_Q00, L2_Q01, L2_Q10, L2_Q11, L2_Q20, L2_Q21, L2_Q30, L2_Q31, L2_Q40, L2_Q41, L2_Q50, L2_Q51, L2_Q60, L2_Q61, L2_Q70, L2_Q71;
    // interface mode
    uchar bInterfaceMode;
  };

// device configuration
// [
// GLP_IOCTL_SET_DEVCFG
struct tGLPDeviceSettings
  {
    dword dLatchDelay;
    dword dBusyDelay;
    dword dBusyTimeOutCount;
  };
// ]

struct tGLPCmdBuffer
  {
    dword dError;
    dword dReturnValue[GLP_RET_NUM_BUFFER_MAX];
    struct tGLPCommand  aCmd[GLP_CMD_NUM_BUFFER_MAX];
    struct tGLPDevState aDevState;
    struct tGLPDeviceSettings aDevSettings; // Diese Parameter werden immer mitbertragen. //
  };
// ]




// basic io instruction set //
#define BIO_CMD_FIRST                                     0
#define BIO_CMD_OUT                                       1
#define BIO_CMD_MOVE                                      2
#define BIO_CMD_IN                                        3
#define BIO_CMD_CLOCK                                     4
#define BIO_CMD_FASTOUT                                   5
#define BIO_CMD_STROBE                                    6
#define BIO_CMD_QUICKBUSY                                 7
#define BIO_CMD_SETINI                                    8
#define BIO_CMD_BUSY                                      9
#define BIO_CMD_DATAOUT                                   10

#define BIO_CMD_READDATATENREG_BYTE                       11
#define BIO_CMD_READDATATENREG_WORD                       12

#define BIO_CMD_DELAY                                     13
#define BIO_CMD_SHORT_DELAY                               14

#define BIO_CMD_STI                                       15    // ENABLE
#define BIO_CMD_CLI                                       16    // DISABLE

#define BIO_CMD_READDATAENREG1_20                         17
#define BIO_CMD_READDATAENREG21_40                        18

#define BIO_CMD_SET_LPT_ADR_BASE                          19
#define BIO_CMD_BUSYSPEED                                 20
#define BIO_CMD_WAITFORNOTBUSY                            21

#define BIO_CMD_GET_KERNEL_VER                            22
#define BIO_CMD_FREEPORT                                  23    // obsolete [because driver::close does this job]
#define BIO_CMD_LASTCMD                                   24

#define BIO_CMD_MAXNR                                     25    // count(instructions)



#undef uchar
#undef dword
#endif // glp_device_h
