#ifndef glp_lpt_hw_h
  #define glp_lpt_hw_h

#include <linux/glp_device.h>

// prototypes //

// construction / destruction
// [
int dev_hw_init();                              // initialize
int dev_hw_done();                              // destruct
// ]

// configuration //
// [
int dev_hw_setLPTAdr(struct tGLPAdrLPT* aNewAdr);              // set LPT-port base address
int dev_hw_getLPTAdr(struct tGLPAdrLPT* aAdr);                         // get current LPT-port base address setting
// ]

// simple IO (HAL)
// [
void dev_hw_direct_write(char bData);           // outb(...)
unsigned char dev_hw_direct_read();             // inb()
void dev_hw_state_write(char bData);
unsigned char dev_hw_state_read();
void dev_hw_ctrl_write(char bData);
unsigned char dev_hw_ctrl_read();
// ]






// DEBUG //

void dev_hw_direct_write_test();




#endif // glp_lpt_hw_h
