#ifndef glp_devcfg_h
  #define glp_devcfg_h

#define __KERNEL__
#define MODULE

#define DEVICE_NAME                                             "galep-lpt"     // logname of this driver
#define DEVICE_VERSION                                          "0.9b"          // version string

#define DEVICE_PROC_SUBDIR_NAME                                 "galep"         // name of subdirectory in proc directory //
#define DEVICE_PROC_FILE_VERSION                                "version"       // name of file in proc directory //
#define DEVICE_PROC_FILE_CONFIG                                 "config"        // name of config file entry
#define DEVICE_PROC_FILE_DEBUG                                  ".debug"        // name of debug file entry

// this major device number is reserved for test applications //
#define DEVICE_MAJOR                                            42              // major device node number


// instruction- / and return buffer size
// [
// see glp_device.h [the userspace programmer must know about buffer-sizes]
// ]

// hdwComm defaults
// [
#define GLP_IOCFG_DEFAULT_BASE                                  0x378           // see galep-dev (init section)
#define GLP_IOCFG_LATCH_DELAY                                   0               // see galep-dev (init section)
#define GLP_IOCFG_BUSY_DELAY                                    0               // see galep-dev (init section)
#define GLP_IOCFG_BUSY_TIMEOUT_COUNT                            10000           // see galep-dev (init section)


//#define GLP_WAITFORBUSY_MAX_DELAY                               1000000         // us ==> 1s //
#define GLP_MEASURE_BUSY_SPEED_MEASURETIME                      6000            // see hdwComm.h [100us]
#define GLP_MEASURE_BUSY_SPEED_TIMEOUT                          1000000000      // see hdwComm.h [5s!] ???
// ]

#include <linux/glp_device.h>

#endif // glp_devcfg_h
