#ifndef glp_cmdExecute_h
 #define glp_cmdExecute_h

typedef void (*tBIOInstruction)(void);

// execution information
// [
extern dword dCmdExecutionPointer;                              // the current buffer index [defined in glp_cmdExecute.c]
// ]

extern tBIOInstruction aBIOInstructionList[BIO_CMD_MAXNR];


// instruction set implementation
// [
void bio_instr_first(void);
void bio_instr_out(void);
void bio_instr_move(void);
void bio_instr_in(void);
void bio_instr_clock(void);
void bio_instr_fastout(void);
void bio_instr_strobe(void);
void bio_instr_quick_busy(void);
void bio_instr_set_ini(void);
void bio_instr_busy(void);
void bio_instr_data_out(void);
void bio_instr_read_data_ten_reg_byte(void);
void bio_instr_read_data_ten_reg_word(void);
void bio_instr_delay(void);
void bio_instr_enable(void);
void bio_instr_disable(void);
void bio_instr_read_data_en_reg1_20(void);
void bio_instr_read_data_en_reg21_40(void);
void bio_instr_set_lpt_adr_base(void);
void bio_instr_measure_busy_speed(void);
void bio_instr_wait_for_not_busy(void);
void bio_instr_get_kernel_ver(void);
void bio_instr_free_lpt_port(void);
void bio_instr_last_cmd(void);
// ]

// interpreter
// [
extern int ibio_instr_execute_result;
uchar bio_instr_execute_buffer();
// ]

#endif // glp_cmdExecute_h
