#include "../h/glp_devcfg.h"
#include "../h/glp_types.h"
#include "../h/glp_private.h"
#include "../h/glp_devhw.h"
#include "../h/glp_basicio.h"
#include "../h/glp_hdwdf.h"
#include "../h/glp_hdwComm.h"
#include "../h/glp_rtlstuff.h"

#include <linux/fs.h>         /* Definitionen fr Zeichentreiber             */
#include <linux/wrapper.h>    /* Kompatibilitaets-Headerfile                 */
#include <linux/fcntl.h>      /* ? */

#include <linux/init.h>       /* ? */
#include <linux/config.h>     /* ? */
#include <linux/errno.h>      /* "bekannte" Fehlermeldungen                  */
#include <linux/major.h>      /* ? */
#include <linux/sched.h>      /* ? */
//#include <linux/malloc.h>
#include <linux/slab.h>       // instead of malloc.h
#include <linux/delay.h>      /* ? */

#include <linux/kernel.h>     /* ... fuer Kernel Code                        */
#include <linux/module.h>     /* ... speziell fuer Module                    */
#include <linux/proc_fs.h>    /* Wir benoetigen das Proc-Dateisystem         */

#include <asm/uaccess.h>      // copy_to_user



dword hwcWaitForNotBusy()
  {
    dword dTime = 0;

    while (BIOREF.busy(&BIOREF))
      {
        dTime++;
        if (dTime > aPrivate.aIOCfg.dBusyTimeOutCount)
          return (false);
      }

    return (true);
  }

void hwcSwitchInterfaceMode(uchar bMode)
  {
//    printk (DEVICE_NAME "  hwcSwitchInterfaceMode (glp_hdwComm.c line %d) Nicht Optimal,\n         da Voreinstellungen nicht bercksichtigt!\n", __LINE__);
//    if (bMode != aPrivate.aGlobal.bInterfaceMode) //Aktueller Mode?
//    if (bMode != aPrivate.bInterfaceMode) //Aktueller Mode?
      {
//        aPrivate.aGlobal.bInterfaceMode = bMode;
        aPrivate.aCmdBuffer.aDevState.bInterfaceMode = bMode;
        BIOREF.dataOut(&BIOREF, ADR_Q7 | bMode);
      }
  }

void hwcSetReadbackChannel(uchar bChannel)
  {
    hwcSwitchInterfaceMode(CLOCK_MODE);
    BIOREF.dataOut(&BIOREF, ADR_Q5 | bChannel); //slout_clk
  }

void hwcSoftwareReset()
  {
    printk(DEVICE_NAME "software-reset is not implemented yet\n");
  }

void hwcSetL1_Q00()
  {
    if(!_L1_Q00)
      {
        _L1_Q00 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q00 | _L1_Q00 | _L1_Q01 );
      }
  }

void hwcSetL1_Q01()
  {
    if(!_L1_Q01)
      {
        _L1_Q01 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q00 | _L1_Q00 | _L1_Q01 );
      }
  }

void hwcSetL1_Q10()
  {
    if(!_L1_Q10)
      {
        _L1_Q10 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q10 | _L1_Q10 | _L1_Q11 );
      }
  }

void hwcSetL1_Q11()
  {
    if(!_L1_Q11)
      {
        _L1_Q11 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q10 | _L1_Q10 | _L1_Q11 );
      }
  }

void hwcSetL1_Q20()
  {
    if(!_L1_Q20)
      {
        _L1_Q20 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q20 | _L1_Q20 | _L1_Q21 );
      }
  }

void hwcSetL1_Q21()
  {
    if(!_L1_Q21)
      {
        _L1_Q21 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q20 | _L1_Q20 | _L1_Q21 );
      }
  }

void hwcSetL1_Q30()
  {
    if(!_L1_Q30)
      {
        _L1_Q30 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q30 | _L1_Q30 | _L1_Q31 );
      }
  }

void hwcSetL1_Q31()
  {
    if(!_L1_Q31)
      {
        _L1_Q31 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q30 | _L1_Q30 | _L1_Q31 );
      }
  }

void hwcSetL1_Q40()
  {
    if(!_L1_Q40)
      {
        _L1_Q40 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q40 | _L1_Q40 | _L1_Q41 );
      }
  }

void hwcSetL1_Q41()
  {
    if(!_L1_Q41)
      {
        _L1_Q41 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q40 | _L1_Q40 | _L1_Q41 );
      }
  }

void hwcSetL1_Q50()
  {
    if(!_L1_Q50)
      {
        _L1_Q50 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q50 | _L1_Q50 | _L1_Q51 );
      }
  }

void hwcSetL1_Q51()
  {
    if(!_L1_Q51)
      {
        _L1_Q51 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q50 | _L1_Q50 | _L1_Q51 );
      }
  }

void hwcSetL1_Q60()
  {
    if(!_L1_Q60)
      {
        _L1_Q60 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q60 | _L1_Q60 | _L1_Q61 );
      }
  }

void hwcSetL1_Q61()
  {
    if(!_L1_Q61)
      {
        _L1_Q61 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q60 | _L1_Q60 | _L1_Q61 );
      }
  }

void hwcSetL1_Q70()
  {
    if(!_L1_Q70)
      {
        _L1_Q70 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q70 | _L1_Q70 | _L1_Q71 );
      }
  }

void hwcSetL1_Q71()
  {
    if(!_L1_Q71)
      {
        _L1_Q71 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q70 | _L1_Q70 | _L1_Q71 );
      }
  }

void hwcResetL1_Q00()
  {
    if(_L1_Q00)
      {
        _L1_Q00 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q00 | _L1_Q00 | _L1_Q01 );
      }
  }

void hwcResetL1_Q01()
  {
    if(_L1_Q01)
      {
        _L1_Q01 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q00 | _L1_Q00 | _L1_Q01 );
      }
  }

void hwcResetL1_Q10()
  {
    if(_L1_Q10)
      {
        _L1_Q10 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q10 | _L1_Q10 | _L1_Q11 );
      }
  }

void hwcResetL1_Q11()
  {
    if(_L1_Q11)
      {
        _L1_Q11 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q10 | _L1_Q10 | _L1_Q11 );
      }
  }

void hwcResetL1_Q20()
  {
    if(_L1_Q20)
      {
        _L1_Q20 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q20 | _L1_Q20 | _L1_Q21 );
      }
  }

void hwcResetL1_Q21()
  {
    if(_L1_Q21)
      {
        _L1_Q21 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q20 | _L1_Q20 | _L1_Q21 );
      }
  }

void hwcResetL1_Q30()
  {
    if(_L1_Q30)
      {
        _L1_Q30 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q30 | _L1_Q30 | _L1_Q31 );
      }
  }

void hwcResetL1_Q31()
  {
    if(_L1_Q31)
      {
        _L1_Q31 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q30 | _L1_Q30 | _L1_Q31 );
      }
  }

void hwcResetL1_Q40()
  {
    if(_L1_Q40)
      {
        _L1_Q40 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q40 | _L1_Q40 | _L1_Q41 );
      }
  }

void hwcResetL1_Q41()
  {
    if(_L1_Q41)
      {
        _L1_Q41 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q40 | _L1_Q40 | _L1_Q41 );
      }
  }

void hwcResetL1_Q50()
  {
    if(_L1_Q50)
      {
        _L1_Q50 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q50 | _L1_Q50 | _L1_Q51 );
      }
  }

void hwcResetL1_Q51()
  {
    if(_L1_Q51)
      {
        _L1_Q51 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q50 | _L1_Q50 | _L1_Q51 );
      }
  }

void hwcResetL1_Q60()
  {
    if(_L1_Q60)
      {
        _L1_Q60 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q60 | _L1_Q60 | _L1_Q61 );
      }
  }

void hwcResetL1_Q61()
  {
    if(_L1_Q61)
      {
        _L1_Q61 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L1_Q60 | _L1_Q60 | _L1_Q61 );
      }
  }

void hwcResetL1_Q70()
  {
    if(_L1_Q70)
      {
        _L1_Q70 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q70 | _L1_Q70 | _L1_Q71 );
      }
  }

void hwcResetL1_Q71()
  {
    if(_L1_Q71)
      {
        _L1_Q71 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L1_Q70 | _L1_Q70 | _L1_Q71 );
      }
  }

void hwcSetL2_Q00()
  {
    if(!_L2_Q00)
      {
        _L2_Q00 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q00 | _L2_Q00 | _L2_Q01 );
      }
  }

void hwcSetL2_Q01()
  {
    if(!_L2_Q01)
      {
        _L2_Q01 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q00 | _L2_Q00 | _L2_Q01 );
      }
  }

void hwcSetL2_Q10()
  {
    if(!_L2_Q10)
      {
        _L2_Q10 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q10 | _L2_Q10 | _L2_Q11 );
      }
  }

void hwcSetL2_Q11()
  {
    if(!_L2_Q11)
      {
        _L2_Q11 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q10 | _L2_Q10 | _L2_Q11 );
      }
  }

void hwcSetL2_Q20()
  {
    if(!_L2_Q20)
      {
        _L2_Q20 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q20 | _L2_Q20 | _L2_Q21 );
      }
  }

void hwcSetL2_Q21()
  {
    if(!_L2_Q21)
      {
        _L2_Q21 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q20 | _L2_Q20 | _L2_Q21 );
      }
  }

void hwcSetL2_Q30()
  {
    if(!_L2_Q30)
      {
        _L2_Q30 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q30 | _L2_Q30 | _L2_Q31 );
      }
  }

void hwcSetL2_Q31()
  {
    if(!_L2_Q31)
      {
        _L2_Q31 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q30 | _L2_Q30 | _L2_Q31 );
      }
  }

void hwcSetL2_Q40()
  {
    if(!_L2_Q40)
      {
        _L2_Q40 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q40 | _L2_Q40 | _L2_Q41 );
      }
  }

void hwcSetL2_Q41()
  {
    if(!_L2_Q41)
      {
        _L2_Q41 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q40 | _L2_Q40 | _L2_Q41 );
      }
  }

void hwcSetL2_Q50()
  {
    if(!_L2_Q50)
      {
        _L2_Q50 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q50 | _L2_Q50 | _L2_Q51 );
      }
  }

void hwcSetL2_Q51()
  {
    if(!_L2_Q51)
      {
        _L2_Q51 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q50 | _L2_Q50 | _L2_Q51 );
      }
  }

void hwcSetL2_Q60()
  {
    if(!_L2_Q60)
      {
        _L2_Q60 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q60 | _L2_Q60 | _L2_Q61 );
      }
  }

void hwcSetL2_Q61()
  {
    if(!_L2_Q61)
      {
        _L2_Q61 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q60 | _L2_Q60 | _L2_Q61 );
      }
  }

void hwcSetL2_Q70()
  {
    if(!_L2_Q70)
      {
        _L2_Q70 = D0_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q70 | _L2_Q70 | _L2_Q71 );
      }
  }

void hwcSetL2_Q71()
  {
    if(!_L2_Q71)
      {
        _L2_Q71 = D1_HIGH;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q70 | _L2_Q70 | _L2_Q71 );
      }
  }

void hwcResetL2_Q00()
  {
    if(_L2_Q00)
      {
        _L2_Q00 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q00 | _L2_Q00 | _L2_Q01 );
      }
  }

void hwcResetL2_Q01()
  {
    if(_L2_Q01)
      {
        _L2_Q01 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q00 | _L2_Q00 | _L2_Q01 );
      }
  }

void hwcResetL2_Q10()
  {
    if(_L2_Q10)
      {
        _L2_Q10 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q10 | _L2_Q10 | _L2_Q11 );
      }
  }

void hwcResetL2_Q11()
  {
    if(_L2_Q11)
      {
        _L2_Q11 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q10 | _L2_Q10 | _L2_Q11 );
      }
  }

void hwcResetL2_Q20()
  {
    if(_L2_Q20)
      {
        _L2_Q20 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q20 | _L2_Q20 | _L2_Q21 );
      }
  }

void hwcResetL2_Q21()
  {
    if(_L2_Q21)
      {
        _L2_Q21 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q20 | _L2_Q20 | _L2_Q21 );
      }
  }

void hwcResetL2_Q30()
  {
    if(_L2_Q30)
      {
        _L2_Q30 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q30 | _L2_Q30 | _L2_Q31 );
      }
  }

void hwcResetL2_Q31()
  {
    if(_L2_Q31)
      {
        _L2_Q31 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q30 | _L2_Q30 | _L2_Q31 );
      }
  }

void hwcResetL2_Q40()
  {
    if(_L2_Q40)
      {
        _L2_Q40 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q40 | _L2_Q40 | _L2_Q41 );
      }
  }

void hwcResetL2_Q41()
  {
    if(_L2_Q41)
      {
        _L2_Q41 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q40 | _L2_Q40 | _L2_Q41 );
      }
  }

void hwcResetL2_Q50()
  {
    if(_L2_Q50)
      {
        _L2_Q50 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q50 | _L2_Q50 | _L2_Q51 );
      }
  }

void hwcResetL2_Q51()
  {
    if(_L2_Q51)
      {
        _L2_Q51 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q50 | _L2_Q50 | _L2_Q51 );
      }
  }

void hwcResetL2_Q60()
  {
    if(_L2_Q60)
      {
        _L2_Q60 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q60 | _L2_Q60 | _L2_Q61 );
      }
  }

void hwcResetL2_Q61()
  {
    if(_L2_Q61)
      {
        _L2_Q61 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q60 | _L2_Q60 | _L2_Q61 );
      }
  }

void hwcResetL2_Q70()
  {
    if(_L2_Q70)
      {
        _L2_Q70 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF,	ADR_L2_Q70 | _L2_Q70 | _L2_Q71 );
      }
  }

void hwcResetL2_Q71()
  {
    if(_L2_Q71)
      {
        _L2_Q71 = 0;
        hwcSwitchInterfaceMode(LATCH_MODE);
        BIOREF.dataOut(&BIOREF, ADR_L2_Q70 | _L2_Q70 | _L2_Q71 );
      }
  }


// SpeedUp functions //
void hwcSetM0()
  {
    hwcSetL1_Q10();
  }

void hwcResetM0()
  {
    hwcResetL1_Q10();
  }

void hwcSetM1()
  {
    hwcSetL1_Q11();
  }

void hwcResetM1()
  {
    hwcResetL1_Q11();
  }

void hwcSetEndo()
  {
    hwcSetL1_Q00();
  }

void hwcResetEndo()
  {
    hwcResetL1_Q00();
  }


uint hwcReadDataRegByte()
  {
    uint uidata = 0;
    uint i;
//Betriebsart des Datenregisters setzen;
//Shift 1bit seriell;
    hwcSetM1();
    hwcResetEndo();        		                // Ausgang disable;
    hwcSetReadbackChannel(OUT_D1); 	                // Ruecklesekanal setzen;
//Schnittstelle ist durch "SetReadbackChannel(OUT_Q1);" schon im Clock-Modus;
    for(i = 0;i < 8;i++)
      {
        uidata <<=1;
        if (BIOREF.busy(&BIOREF))
          uidata |=0x0001;
        else
	  uidata &=0xFFFE;
//uidata <<=1;
	BIOREF.dataOut(&BIOREF, ADR_Q0);        	// Impuls auf DL;
      }
    return(uidata);
  }

uint hwcReadDataRegWord()
  {
    uint uidata = 0;
    uint i;
    //Betriebsart des Datenregisters setzen;
    //Shift 1bit seriell;
    hwcSetM1();
    hwcResetEndo();	//Ausgang disable;
    hwcSetReadbackChannel(OUT_D1); //Ruecklesekanal setzen;
    //Schnittstelle ist durch "SetReadbackChannel(OUT_Q1);" schon im Clock-Modus;
    for(i = 0;i < 16;i++)
      {
        uidata <<=1;

        if (BIOREF.busy(&BIOREF))
          uidata |=0x0001;
        else
          uidata &=0xFFFE;
    //uidata <<=1;
        BIOREF.dataOut(&BIOREF, ADR_Q0);	//Impuls auf DL;
       }
    return(uidata);
  }

dword hwcReadDataRegPin1_20()
  {
    dword uldata = 0;
    uint i;
    //Betriebsart des Datenregisters setzen;
    //Shift 1bit seriell;
    hwcSetM1();
    hwcSetReadbackChannel(OUT_D5); //Ruecklesekanal setzen;
    //Schnittstelle ist durch "SetReadbackChannel(OUT_Q1);" schon im Clock-Modus;
    for(i = 0;i < 20;i++)
      {
        uldata <<=1;
        if(BIOREF.busy(&BIOREF))
          uldata |=0x00001ul;//"1"
        else
          uldata &=0xFFFFEul;//"0"

        BIOREF.dataOut(&BIOREF, ADR_Q0);	//Impuls auf DL;
      }
    return(uldata);
  }

dword hwcReadDataRegPin21_40()
  {
    dword uldata = 0;
    uint i;
    // Betriebsart des Datenregisters setzen;
    //Shift 1bit seriell;
    hwcSetM1();
    hwcSetReadbackChannel(OUT_D6); //Ruecklesekanal setzen;
    //Schnittstelle ist durch "SetReadbackChannel(OUT_Q1);" schon im Clock-Modus;
    for(i = 0;i < 20;i++)
      {
        uldata <<=1;
        if(BIOREF.busy(&BIOREF))
          uldata |=0x00001;//"1"
        else
          uldata &=0xFFFFEl;//"0"

        BIOREF.dataOut(&BIOREF, ADR_Q0);	//Impuls auf DL
		//DataOut(ADR_Q1);	//Impuls auf ACLK;
      }
    return(uldata);
  }

dword hwcMeasureBusySpeed()
  {
    long dCount = 0;
    printk (DEVICE_NAME " dword hwcMeasureBusySpeed() (glp_hdwComm.c line %d) needs a timeout = 5s!!!!!\n", __LINE__);
    hwcLoadTimerSerReg (hwcCalcTimerValue(GLP_MEASURE_BUSY_SPEED_MEASURETIME));  // 100s;
    glp_rtl_disable();                                  // shut down "all" interrupt sources
    hwcStartPgmImpulse();				// Zeitmessung starten;
    hwcSetReadbackChannel(OUT_D3);			// Ruecklesekanal auf Timersignal;
    while(BIOREF.busy(&BIOREF))
      {
       dCount++;
       if (dCount > GLP_MEASURE_BUSY_SPEED_TIMEOUT)
         break;
      }
    glp_rtl_enable();                                   // weak all them up
    // count muss in jedem Fall groesser "1" sein;
    if((dCount < 1) || (dCount > GLP_MEASURE_BUSY_SPEED_TIMEOUT))
      {
        printk(DEVICE_NAME "measurebusyspeed failed!\n");
        return false;
      }

   printk(DEVICE_NAME "measurebusyspeed: %ld!\n", dCount);
   aPrivate.aCmdBuffer.aDevSettings.dBusyTimeOutCount = dCount;
   aPrivate.aCmdBuffer.dReturnValue[1] = dCount;
   return true;
  }

uint hwcCalcTimerValue(dword dUSec)
  {
    return(0xFFFF - (uint)(dUSec/2)+1);//+1, weil der Zhler erst bei 0x0000 stehen bleibt.
  }

void hwcLoadTimerSerReg(uint iTimerVal)
  {
    uint bit = 0;
    int i = 0;
    hwcSwitchInterfaceMode(CLOCK_MODE);	//Schnittstelle auf CLOCK-Modus schalten;
    for(i = 0;i < 16;i++)  		//Uebertragung TimerWerts;
      {
        bit = 0x8000 & iTimerVal;	//MSB isolieren;
        bit >>=15; 			//MSB nach PC0 schieben;
        BIOREF.dataOut(&BIOREF, ADR_Q3|bit);	        //Clockimpuls und Bit ber PD0 an Galep senden;
        iTimerVal <<=1;	  	//Naechstes Bit bitte;
      }
  }

void hwcStartPgmImpulse()
  {
    hwcSwitchInterfaceMode(CLOCK_MODE);	//Schnittstelle auf CLOCK-Modus schalten;	DataOut(ADR_SPGM);
    BIOREF.dataOut(&BIOREF, ADR_Q2);
  }

