#include <asm/io.h>

#include "../h/glp_devcfg.h"
#include "../h/glp_private.h"

#include <linux/fs.h>         /* Definitionen fr Zeichentreiber             */
#include <linux/wrapper.h>    /* Kompatibilitaets-Headerfile                 */
#include <linux/fcntl.h>      /* ? */

#include <linux/init.h>       /* ? */
#include <linux/config.h>     /* ? */
#include <linux/errno.h>      /* "bekannte" Fehlermeldungen                  */
#include <linux/major.h>      /* ? */
#include <linux/sched.h>      /* ? */
//#include <linux/malloc.h>
#include <linux/slab.h>       // instead of malloc.h
#include <linux/delay.h>      /* ? */

#include <linux/kernel.h>     /* ... fuer Kernel Code                        */
#include <linux/module.h>     /* ... speziell fuer Module                    */
#include <linux/proc_fs.h>    /* Wir benoetigen das Proc-Dateisystem         */

int dev_hw_init()
  {
    return (0);
  }


int dev_hw_done()
  {
    return (0);
  }

int dev_hw_setLPTAdr(struct tGLPAdrLPT* aAdr)
  {
    aPrivate.aLPTAddr = *aAdr;
    printk (DEVICE_NAME "  + try to set HW-Adr\n      + IO-Address: %d\n      + ST-Address: %d\n      + CT-Address: %d\n\n", aPrivate.aLPTAddr.iIOPortAddr, aPrivate.aLPTAddr.iSTPortAddr, aPrivate.aLPTAddr.iCTPortAddr);
    return (0);
  }

int dev_hw_getLPTAdr(struct tGLPAdrLPT* aAdr)
  {
    *aAdr = aPrivate.aLPTAddr;
    printk (DEVICE_NAME "  + get HW-Adr\n");
    return (0);
  }


// ]




void dev_hw_direct_write(char bData)
  {

    outb((uchar)bData, aPrivate.aLPTAddr.iIOPortAddr);
//    printk(DEVICE_NAME "       + direct write [IO] %d\n", (uchar)bData);
  }

unsigned char dev_hw_direct_read()
  {
    unsigned char bValue = inb(aPrivate.aLPTAddr.iIOPortAddr);
    return (bValue);
  }

void dev_hw_state_write(char bData)
  {
    outb((uchar)bData, aPrivate.aLPTAddr.iSTPortAddr);
//    printk(DEVICE_NAME "  + direct write [STATE] %d\n", bData);
  }

unsigned char dev_hw_state_read()
  {
    unsigned char bValue = inb(aPrivate.aLPTAddr.iSTPortAddr);
//        printk(DEVICE_NAME "dev_hw_state_read(adr:%x, data:%d)\n", aPrivate.aLPTAddr.iSTPortAddr, bValue & 128);
    return (bValue);
  }


void dev_hw_ctrl_write(char bData)
  {
//    printk(DEVICE_NAME "       + dev_hw_ctrl_write(adr:%x, data:%d)\n", aPrivate.aLPTAddr.iCTPortAddr, (uchar)bData);

    outb((uchar)bData, aPrivate.aLPTAddr.iCTPortAddr);
//    printk(DEVICE_NAME "  + direct write [CTRL] %d\n", bData);
  }

unsigned char dev_hw_ctrl_read()
  {
    unsigned char bValue = inb(aPrivate.aLPTAddr.iCTPortAddr);
/*    printk (DEVICE_NAME "FixMe dev_hw_ctrl_read()\n");
    bValue &= 31;*/
    return (bValue);
  }

/* DEBUG STUFF */


/*
void dev_hw_direct_write_test()
  {
    long i = 0;
    long j = 0;
    cli();
    printk(DEVICE_NAME "  + direct write test start...\n");
    for (i=0; i < aPrivate.dWriteTestCnt; i++)
      {
        outb(0x00, aPrivate.iLPTAddr);
//	for (j = 0; j < 10; j++);

        outb(0xff, aPrivate.iLPTAddr);
//	for (j = 0; j < 10; j++);
      }

    sti();
    printk(DEVICE_NAME "  + direct write test stop.\n");
  }
  */
