#include "../h/glp_devcfg.h"  // CFG
#include "../h/glp_devhw.h"   // HAL

#include <linux/kernel.h>     /* ... fuer Kernel Code                        */
#include <linux/module.h>     /* ... speziell fuer Module                    */
#include <linux/proc_fs.h>    /* Wir benoetigen das Proc-Dateisystem         */

#include <linux/init.h>
#include <linux/config.h>
#include <linux/errno.h>      /* "bekannte" Fehlermeldungen                  */
#include <linux/major.h>
#include <linux/sched.h>
//#include <linux/malloc.h>
#include <linux/slab.h>       // instead of malloc.h
#include <linux/fcntl.h>
#include <linux/delay.h>
#include <asm/uaccess.h>      // copy_to_user

/* Speziell fuer Zeichentreiber -------------------------------------------- */

#include <linux/fs.h>         /* Definitionen fr Zeichentreiber             */
#include <linux/wrapper.h>    /* Kompatibilitaets-Headerfile                 */

#include "../h/glp_private.h"
#include "../h/glp_cmdExecute.h"

/* Implementierung aller IOCTL Kommandos */

// IOCTL HANDLER
// [

int dev_ioctl_handle_setlptadr(struct tGLPAdrLPT* aStruct)
  {
    struct tGLPAdrLPT aAdr;
    if (copy_from_user(&aAdr, aStruct, sizeof(aAdr))) return (-EFAULT);
    return (dev_hw_setLPTAdr(&aAdr));
  }

int dev_ioctl_handle_getlptadr(struct tGLPAdrLPT* aStruct)
  {
    struct tGLPAdrLPT aAdr;
    dev_hw_getLPTAdr(&aAdr);
    return (copy_to_user(aStruct, &aAdr, sizeof(aAdr)) ? (-EFAULT) : (0));
  }

int dev_ioctl_handle_bfExecute(struct tGLPCmdBuffer* aStruct)
  {
    int iRes = 0;
    struct tGLPDeviceSettings aDevSettings;

    // copy the struct to kernel-space //
    if (copy_from_user(&aPrivate.aCmdBuffer, aStruct, sizeof(aPrivate.aCmdBuffer))) return (-EFAULT);

    // copy the lpt-param struct from the aCmdBuffer //
    // [
    aPrivate.aIOCfg = aStruct->aDevSettings;
    // ]

    // execute buffer //
    iRes = bio_instr_execute_buffer();

    // copy the lpt-param struct back //
    // [
    aDevSettings = aPrivate.aIOCfg;
    aStruct->aDevSettings = aDevSettings;
    // ]

    // copy error message //
    aPrivate.aCmdBuffer.dError = ibio_instr_execute_result;
    // copy the struct from kernel-space
    if (copy_to_user(aStruct, &aPrivate.aCmdBuffer, sizeof(aPrivate.aCmdBuffer))) return (-EFAULT);
    return (0); // indicates no error
  }

 int dev_ioctl_handle_get_devcfg(struct tGLPDeviceSettings* aStruct)
   {
     if (copy_to_user(aStruct, &aPrivate.aIOCfg, sizeof(*aStruct))) return (-EFAULT);
     return (0);
   }

 int dev_ioctl_handle_set_devcfg(struct tGLPDeviceSettings* aStruct)
   {
     struct tGLPDeviceSettings aSettings;
     if (copy_from_user(&aSettings, aStruct, sizeof(aSettings))) return (-EFAULT);
     aPrivate.aIOCfg = aSettings;
     // do the settings in aInstance too //
     printk(DEVICE_NAME " ----- set configuration data:\n    + latch delay: %ld\n    + busy delay: %ld\n    + busy timeout: %ld\n\n",aPrivate.aIOCfg.dLatchDelay, aPrivate.aIOCfg.dBusyDelay, aPrivate.aIOCfg.dBusyTimeOutCount);
     return (0);
   }
// ]

