#include "../h/glp_devcfg.h"
#include "../h/glp_private.h"
#include "../h/glp_devhw.h"
#include "../h/glp_basicio.h"
#include "../h/glp_hdwComm.h"
#include "../h/glp_cmdExecute.h"
#include "../h/glp_rtlstuff.h"

#include <linux/fs.h>         /* Definitionen fr Zeichentreiber             */
#include <linux/wrapper.h>    /* Kompatibilitaets-Headerfile                 */
#include <linux/fcntl.h>      /* ? */

#include <linux/init.h>       /* ? */
#include <linux/config.h>     /* ? */
#include <linux/errno.h>      /* "bekannte" Fehlermeldungen                  */
#include <linux/major.h>      /* ? */
#include <linux/sched.h>      /* ? */
//#include <linux/malloc.h>
#include <linux/slab.h>       // instead of malloc.h
#include <linux/delay.h>      /* ? */

#include <linux/kernel.h>     /* ... fuer Kernel Code                        */
#include <linux/module.h>     /* ... speziell fuer Module                    */
#include <linux/proc_fs.h>    /* Wir benoetigen das Proc-Dateisystem         */

#include <asm/uaccess.h>      // copy_to_user

dword dCmdExecutionPointer = 0;
int ibio_instr_execute_result = 0;

tBIOInstruction aBIOInstructionList[BIO_CMD_MAXNR] =
  {
    &bio_instr_first,                                   // 00
    &bio_instr_out,                                     // 01
    &bio_instr_move,                                    // 02
    &bio_instr_in,                                      // 03
    &bio_instr_clock,                                   // 04
    &bio_instr_fastout,                                 // 05
    &bio_instr_strobe,                                  // 06
    &bio_instr_quick_busy,                              // 07
    &bio_instr_set_ini,                                 // 08
    &bio_instr_busy,                                    // 09
    &bio_instr_data_out,                                // 10
    &bio_instr_read_data_ten_reg_byte,                  // 11
    &bio_instr_read_data_ten_reg_word,                  // 12
    &bio_instr_delay,                                   // 13
    &bio_instr_delay,                                   // 14
    &bio_instr_enable,                                  // 15
    &bio_instr_disable,                                 // 16
    &bio_instr_read_data_en_reg1_20,                    // 17
    &bio_instr_read_data_en_reg21_40,                   // 18
    &bio_instr_set_lpt_adr_base,                        // 19
    &bio_instr_measure_busy_speed,                      // 20
    &bio_instr_wait_for_not_busy,                       // 21
    &bio_instr_get_kernel_ver,                          // 22
    &bio_instr_free_lpt_port,                           // 23
    &bio_instr_last_cmd                                 // 24
  };



void bio_instr_first(void)
  {
    // unused //
  }

void bio_instr_out(void)
  {
    BIOREF.out(&BIOREF, (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
  }

void bio_instr_move(void)
  {
    BIOREF.move(&BIOREF, (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
  }

void bio_instr_in(void)
  {
//{  pCmdBuf->retvalue[0] = io.in();}
   aPrivate.aCmdBuffer.dReturnValue[0] = BIOREF.in(&BIOREF);

  }

void bio_instr_clock(void)
  {
    BIOREF.clock(&BIOREF);
  }

void bio_instr_fastout(void)
  {
    BIOREF.fastOut(&BIOREF, (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
  }

void bio_instr_strobe(void)
  {
//    printk(DEVICE_NAME " !!!!!!!!!!!!! bio_instr_strobe: %d.\n", (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
    BIOREF.strobe(&BIOREF, (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
  }

void bio_instr_quick_busy(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = BIOREF.quickBusy(&BIOREF);
//    printk(DEVICE_NAME "- ---------------------- > In QuickBusy: %ld.\n", aPrivate.aCmdBuffer.dReturnValue[0]);
  }

void bio_instr_set_ini(void)
  {
    BIOREF.setINI(&BIOREF);
  }

void bio_instr_busy(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = BIOREF.busy(&BIOREF);
//    printk(DEVICE_NAME "- ---------------------- > In Busy: %ld.\n", aPrivate.aCmdBuffer.dReturnValue[0]);
  }

void bio_instr_data_out(void)
  {
//    printk(DEVICE_NAME "data out: 0x%x\n", (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
    BIOREF.dataOut(&BIOREF, (uchar)aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
  }

void bio_instr_read_data_ten_reg_byte(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = hwcReadDataRegByte();
  }

void bio_instr_read_data_ten_reg_word(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = hwcReadDataRegWord();
  }

void bio_instr_read_data_en_reg1_20(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = hwcReadDataRegPin1_20();
  }


void bio_instr_read_data_en_reg21_40(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = hwcReadDataRegPin21_40();
  }


void bio_instr_delay(void)
  {
    long dMsec = aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg / 1000;
    if (!(aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg)) return;
    if (dMsec > 1)
      mdelay(aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg / 1000);
    else
      {
        udelay(aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg);
      }
  }

void bio_instr_unsolvedEnable(void)
  {
    glp_rtl_unsolved_enable();
  }

void bio_instr_unsolvedDisable(void)
  {
    glp_rtl_unsolved_disable();
  }

void bio_instr_enable(void)
  {
    glp_rtl_enable();
  }

void bio_instr_disable(void)
  {
    glp_rtl_disable();
  }

void bio_instr_set_lpt_adr_base(void)
  {
    struct tGLPAdrLPT aNewAdr;
    int iPortBase = aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aArg;
    aNewAdr.iIOPortAddr = iPortBase;
    aNewAdr.iSTPortAddr = iPortBase+1;
    aNewAdr.iCTPortAddr = iPortBase+2;
    dev_hw_setLPTAdr(&aNewAdr);
  }

void bio_instr_measure_busy_speed(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = hwcMeasureBusySpeed();
  }

void bio_instr_wait_for_not_busy(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = hwcWaitForNotBusy();
  }

void bio_instr_get_kernel_ver(void)
  {
    aPrivate.aCmdBuffer.dReturnValue[0] = 0x0204;
  }

void bio_instr_free_lpt_port(void)
  {
    // nothing to do yet //
  }

void bio_instr_last_cmd(void)
  {
    // abort the interpreter by setting the pointer to the last buffer-address //
    dCmdExecutionPointer = GLP_CMD_NUM_BUFFER_MAX;
  }




// interpreter (doIO)
uchar bio_instr_execute_buffer()
  {
    int iInstruction = 0;
    int iInstructionCounter = 0;
    // the user-space buffer is allready copyed (by glp_dev_ioctl) //

    // alte Fehler lschen
    ibio_instr_execute_result = 0;

    // Wenn ein sehr groer Datenblock bertragen wird, der in einer (Priorittsklammerung steht), mu dafr gesorgt
    // werden, dass die Klammerung im nchsten Teil des Blockes weiterhin besteht!
    // [
    if (glp_rtl_getDisabled())
      glp_rtl_unsolved_disable();
    // ]

    for (dCmdExecutionPointer = 0; dCmdExecutionPointer < GLP_CMD_NUM_BUFFER_MAX; dCmdExecutionPointer++)
      {
        iInstruction = aPrivate.aCmdBuffer.aCmd[dCmdExecutionPointer].aCmd;
	      if (iInstruction >= BIO_CMD_MAXNR)
          {
//            printk(DEVICE_NAME " -- -- -- unknwown kernel driver instruction (%d) -- -- --\n", iInstruction);
            ibio_instr_execute_result = GLP_ERR_EXECUTE_INVINSTR;
            glp_rtl_unsolved_enable();
	          return (false);
          }

	// execute instruction //
        (*aBIOInstructionList[iInstruction])();

	// errors ??? //
	if (ibio_instr_execute_result)
	  {
            glp_rtl_unsolved_enable();
	    return (false);
	  }

	iInstructionCounter++;
      }

    glp_rtl_unsolved_enable();
//    printk(DEVICE_NAME " execute: successfully (%d instructions)\n", iInstructionCounter);

    return (true);
  }
