#include "../h/glp_devcfg.h"
#include "../h/glp_basicio.h"
#include "../h/glp_devhw.h"

#include <linux/kernel.h>     /* ... fuer Kernel Code                        */
#include <linux/module.h>     /* ... speziell fuer Module                    */
#include <linux/proc_fs.h>    /* Wir benoetigen das Proc-Dateisystem         */

#include <linux/init.h>
#include <linux/config.h>
#include <linux/errno.h>      /* "bekannte" Fehlermeldungen                  */
#include <linux/major.h>
#include <linux/sched.h>
//#include <linux/malloc.h>
#include <linux/slab.h>       // instead of malloc.h
#include <linux/fcntl.h>
#include <linux/delay.h>
#include <asm/uaccess.h>      // copy_to_user

/* Speziell fuer Zeichentreiber -------------------------------------------- */

#include <linux/fs.h>         /* Definitionen fr Zeichentreiber             */
#include <linux/wrapper.h>    /* Kompatibilitaets-Headerfile                 */

#include "../h/glp_private.h"   // TEST ONLY!!!!

// WARNING !!!!!!!!!!!
// ***********************************************************************************************
// tBasicIO::dLatchDelay must be initialized with tDevicePrivate::tDeviceInterface::dLatchDelay
// ***********************************************************************************************

//#define BIO_CLASS_DEBUG

#ifdef BIO_CLASS_DEBUG
  #define BIO_DBG(sym) printk(DEVICE_NAME "   + tBasicIO::" sym "\n");
#else
  #define BIO_DBG(sym)
#endif


void bio_out(struct tBasicIO* aInstance, uchar bData)
  {
    BIO_DBG("bio_out [bData]");
    dev_hw_direct_write (bData);
  }

void bio_move(struct tBasicIO* aInstance, uchar bData)
  {
//    BIO_DBG("bio_move [bData]");
    dev_hw_direct_write ((dev_hw_direct_read() & 0x80) | (bData));
  }

uchar bio_in(struct tBasicIO* aInstance)
  {
    BIO_DBG("bio_in");
    return (dev_hw_direct_read());
  }

void bio_clock(struct tBasicIO* aInstance)
  {
    BIO_DBG("bio_clock");
    dev_hw_direct_write(dev_hw_direct_read()^0x80);
  }


void bio_fastOut(struct tBasicIO* aInstance, uchar bData)
  {
    BIO_DBG("bio_fastOut [bData]");
    dev_hw_direct_write(((dev_hw_direct_read()^0x80) & 0x80)| bData);
  }


void bio_strobe(struct tBasicIO* aInstance, uchar bData)
  {
    uchar iVal = (dev_hw_ctrl_read() & 0xDE) | bData;
    BIO_DBG("bio_strobe");
    dev_hw_ctrl_write(iVal);
  }

uchar bio_quickBusy(struct tBasicIO* aInstance)
  {
    BIO_DBG("bio_quickBusy");
    return ((dev_hw_state_read() & 0x80)^0x80);
  }

void bio_setINI(struct tBasicIO* aInstance)
  {
    BIO_DBG("bio_setINI");
    dev_hw_ctrl_write(dev_hw_ctrl_read() | 0xe4);
  }


uchar bio_busy(struct tBasicIO* aInstance)
  {
    long dTime = 0;
    BIO_DBG("bio_busy");
//    for (dTime = 0; dTime < aInstance->aDevCfg->dBusyDelay; dTime++)

/*    printk(DEVICE_NAME "busy delay (instance): %ld\n", aInstance->aDevCfg->dBusyDelay);
    printk(DEVICE_NAME "busy delay (private) : %ld\n", aPrivate.aIOCfg.dBusyDelay);*/
    for (dTime = 0; dTime < aInstance->aDevCfg->dBusyDelay; dTime++);
      dev_hw_state_read();
//    printk(DEVICE_NAME "       + busy state: %d\n", dev_hw_state_read());
    return ((dev_hw_state_read() & 0x80)^0x80);
  }

// berprfen, ob zwischen Daten und Latchimpuls eine Verzgerung eingefgt werden mu.
// !Langsam steigende Flanken!
void bio_dataOut(struct tBasicIO* aInstance, uchar bData)
  {
    long dTime = 0;
    BIO_DBG("bio_dataOut [bData]");

    if (aInstance->aDevCfg->dLatchDelay)
      {
        aInstance->move(aInstance, bData);
	for (dTime = 0; dTime < aInstance->aDevCfg->dLatchDelay; dTime++)
          aInstance->move(aInstance, bData);
        aInstance->clock(aInstance);
      }
    else
      aInstance->fastOut(aInstance, bData);
  }


void tBasicIO_construct(struct tBasicIO* aInstance, struct tGLPDeviceSettings* aDevCfg)
  {
    // initialize MT //
    aInstance->out = bio_out;
    aInstance->move = bio_move;
    aInstance->in = bio_in;
    aInstance->clock = bio_clock;
    aInstance->fastOut = bio_fastOut;
    aInstance->strobe = bio_strobe;
    aInstance->quickBusy = bio_quickBusy;
    aInstance->setINI = bio_setINI;
    aInstance->busy = bio_busy;
    aInstance->dataOut = bio_dataOut;

    // initialize all variables //
    aInstance->aDevCfg = aDevCfg;
  }
